/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.common.ritual.RitualFactory;
import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.ritual.pentacle.PentacleManager;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RitualRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation pentacleId;
    private final ResourceLocation ritualType;
    private final ResourceLocation spiritJobType;
    private final Ritual ritual;
    private final ItemStack ritualDummy;
    private final Ingredient activationItem;
    private final ITag<EntityType<?>> entityToSacrifice;
    private final EntityType<?> entityToSummon;
    private final Ingredient itemToUse;
    private final int duration;
    private final int spiritMaxAge;
    private final float durationPerIngredient;
    private final String entityToSacrificeDisplayName;

    public RitualRecipe(ResourceLocation id, String group, ResourceLocation pentacleId, ResourceLocation ritualType, ItemStack ritualDummy, ItemStack result, EntityType<?> entityToSummon, Ingredient activationItem, NonNullList<Ingredient> input, int duration, int spiritMaxAge, ResourceLocation spiritJobType, ITag<EntityType<?>> entityToSacrifice, String entityToSacrificeDisplayName, Ingredient itemToUse) {
        super(id, group, result, input);
        this.entityToSummon = entityToSummon;
        this.pentacleId = pentacleId;
        this.ritualType = ritualType;
        this.ritual = ((RitualFactory)OccultismRituals.RITUAL_FACTORY_REGISTRY.getValue(this.ritualType)).create(this);
        this.ritualDummy = ritualDummy;
        this.activationItem = activationItem;
        this.duration = duration;
        this.spiritMaxAge = spiritMaxAge;
        this.spiritJobType = spiritJobType;
        this.durationPerIngredient = (float)this.duration / (float)(this.func_192400_c().size() + 1);
        this.entityToSacrifice = entityToSacrifice;
        this.entityToSacrificeDisplayName = entityToSacrificeDisplayName;
        this.itemToUse = itemToUse;
    }

    public ResourceLocation getPentacleId() {
        return this.pentacleId;
    }

    public Pentacle getPentacle() {
        return PentacleManager.get(this.pentacleId);
    }

    public ItemStack getRitualDummy() {
        return this.ritualDummy;
    }

    public Ingredient getActivationItem() {
        return this.activationItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getDurationPerIngredient() {
        return this.durationPerIngredient;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean matches(World world, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.ritual.identify(world, goldenBowlPosition, activationItem);
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inventoryCrafting) {
        return null;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)OccultismRecipes.RITUAL_TYPE.get();
    }

    public ITag<EntityType<?>> getEntityToSacrifice() {
        return this.entityToSacrifice;
    }

    public boolean requiresSacrifice() {
        return this.entityToSacrifice != null;
    }

    public Ingredient getItemToUse() {
        return this.itemToUse;
    }

    public boolean requiresItemUse() {
        return this.itemToUse != Ingredient.field_193370_a;
    }

    public EntityType<?> getEntityToSummon() {
        return this.entityToSummon;
    }

    public ResourceLocation getRitualType() {
        return this.ritualType;
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    public String getEntityToSacrificeDisplayName() {
        return this.entityToSacrificeDisplayName;
    }

    public ResourceLocation getSpiritJobType() {
        return this.spiritJobType;
    }

    public int getSpiritMaxAge() {
        return this.spiritMaxAge;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RitualRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        public RitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            ResourceLocation ritualType = new ResourceLocation(json.get("ritual_type").getAsString());
            EntityType entityToSummon = null;
            if (json.has("entity_to_summon")) {
                entityToSummon = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"entity_to_summon")));
            }
            JsonArray activationItemElement = JSONUtils.func_151202_d((JsonObject)json, (String)"activation_item") ? JSONUtils.func_151214_t((JsonObject)json, (String)"activation_item") : JSONUtils.func_152754_s((JsonObject)json, (String)"activation_item");
            Ingredient activationItem = Ingredient.func_199802_a((JsonElement)activationItemElement);
            ResourceLocation pentacleId = new ResourceLocation(json.get("pentacle_id").getAsString());
            int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)30);
            int spiritMaxAge = JSONUtils.func_151208_a((JsonObject)json, (String)"spirit_max_age", (int)-1);
            ResourceLocation spiritJobType = null;
            if (json.has("spirit_job_type")) {
                spiritJobType = new ResourceLocation(json.get("spirit_job_type").getAsString());
            }
            ItemStack ritualDummy = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"ritual_dummy"), (boolean)true);
            ITag entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (json.has("entity_to_sacrifice")) {
                entityToSacrifice = TagCollectionManager.func_242178_a().func_241838_d().func_241834_b(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject("entity_to_sacrifice"), (String)"tag")));
                entityToSacrificeDisplayName = json.getAsJsonObject("entity_to_sacrifice").get("display_name").getAsString();
            }
            Ingredient itemToUse = Ingredient.field_193370_a;
            if (json.has("item_to_use")) {
                JsonArray itemToUseElement = JSONUtils.func_151202_d((JsonObject)json, (String)"item_to_use") ? JSONUtils.func_151214_t((JsonObject)json, (String)"item_to_use") : JSONUtils.func_152754_s((JsonObject)json, (String)"item_to_use");
                itemToUse = Ingredient.func_199802_a((JsonElement)itemToUseElement);
            }
            return new RitualRecipe(recipeId, group, pentacleId, ritualType, ritualDummy, result, entityToSummon, activationItem, ingredients, duration, spiritMaxAge, spiritJobType, entityToSacrifice, entityToSacrificeDisplayName, itemToUse);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)pIngredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public RitualRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = serializer.func_199426_a_(recipeId, buffer);
            ResourceLocation ritualType = buffer.func_192575_l();
            EntityType entityToSummon = null;
            if (buffer.readBoolean()) {
                entityToSummon = (EntityType)buffer.readRegistryId();
            }
            ResourceLocation pentacleId = buffer.func_192575_l();
            int duration = buffer.func_150792_a();
            int spiritMaxAge = buffer.func_150792_a();
            ResourceLocation spiritJobType = null;
            if (buffer.readBoolean()) {
                spiritJobType = buffer.func_192575_l();
            }
            ItemStack ritualDummy = buffer.func_150791_c();
            Ingredient activationItem = Ingredient.func_199566_b((PacketBuffer)buffer);
            ITag entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (buffer.readBoolean()) {
                entityToSacrifice = TagCollectionManager.func_242178_a().func_241838_d().func_241834_b(buffer.func_192575_l());
                entityToSacrificeDisplayName = buffer.func_218666_n();
            }
            Ingredient itemToUse = Ingredient.field_193370_a;
            if (buffer.readBoolean()) {
                itemToUse = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            return new RitualRecipe(recipe.func_199560_c(), recipe.func_193358_e(), pentacleId, ritualType, ritualDummy, recipe.func_77571_b(), entityToSummon, activationItem, (NonNullList<Ingredient>)recipe.func_192400_c(), duration, spiritMaxAge, spiritJobType, entityToSacrifice, entityToSacrificeDisplayName, itemToUse);
        }

        public void toNetwork(PacketBuffer buffer, RitualRecipe recipe) {
            serializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
            buffer.func_192572_a(recipe.ritualType);
            buffer.writeBoolean(recipe.entityToSummon != null);
            if (recipe.entityToSummon != null) {
                buffer.writeRegistryId((IForgeRegistryEntry)recipe.entityToSummon);
            }
            buffer.func_192572_a(recipe.pentacleId);
            buffer.func_150787_b(recipe.duration);
            buffer.func_150787_b(recipe.spiritMaxAge);
            buffer.writeBoolean(recipe.spiritJobType != null);
            if (recipe.spiritJobType != null) {
                buffer.func_192572_a(recipe.spiritJobType);
            }
            buffer.func_150788_a(recipe.ritualDummy);
            recipe.activationItem.func_199564_a(buffer);
            buffer.writeBoolean(recipe.entityToSacrifice != null);
            if (recipe.entityToSacrifice != null) {
                buffer.func_192572_a(TagCollectionManager.func_242178_a().func_241838_d().func_232973_a_(recipe.entityToSacrifice));
                buffer.func_180714_a(recipe.entityToSacrificeDisplayName);
            }
            buffer.writeBoolean(recipe.itemToUse != Ingredient.field_193370_a);
            if (recipe.itemToUse != Ingredient.field_193370_a) {
                recipe.itemToUse.func_199564_a(buffer);
            }
        }
    }
}

