/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpiritTradeRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();

    public SpiritTradeRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> input) {
        super(id, group, result, input);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inventoryCrafting) {
        return null;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get();
    }

    public List<ItemStack> consume(List<ItemStack> input) {
        List<ItemStack> result = input.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        for (Ingredient ingredient : this.func_192400_c()) {
            Iterator<ItemStack> it = result.iterator();
            while (it.hasNext()) {
                ItemStack stack = it.next();
                if (!ingredient.test(stack)) continue;
                stack.func_190918_g(1);
                if (!stack.func_190926_b()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean isValid(ItemStack ... input) {
        return this.isValid(Arrays.asList(input));
    }

    public boolean isValid(List<ItemStack> input) {
        List cached = input.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        for (Ingredient ingredient : this.func_192400_c()) {
            boolean matched = false;
            Iterator it = cached.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (!ingredient.test(stack)) continue;
                matched = true;
                stack.func_190918_g(1);
                if (!stack.func_190926_b()) continue;
                it.remove();
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SpiritTradeRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        public SpiritTradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = serializer.func_199425_a_(recipeId, json);
            return new SpiritTradeRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public SpiritTradeRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = serializer.func_199426_a_(recipeId, buffer);
            return new SpiritTradeRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public void toNetwork(PacketBuffer buffer, SpiritTradeRecipe recipe) {
            serializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
        }
    }
}

