/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.advancement.RitualTrigger;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.TickTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OccultismAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<ResourceLocation, Advancement> advancements;

    public OccultismAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
        this.advancements = new HashMap<ResourceLocation, Advancement>();
    }

    private static TranslationTextComponent text(String name, String type) {
        return new TranslationTextComponent("advancements.occultism." + name + "." + type);
    }

    public static TranslationTextComponent title(String name) {
        return OccultismAdvancementProvider.text(name, "title");
    }

    public static TranslationTextComponent descr(String name) {
        return OccultismAdvancementProvider.text(name, "description");
    }

    private static TranslationTextComponent familiarText(String name, String type) {
        return new TranslationTextComponent("advancements.occultism.familiar." + name + "." + type);
    }

    public static TranslationTextComponent familiarTitle(String name) {
        return OccultismAdvancementProvider.familiarText(name, "title");
    }

    public static TranslationTextComponent familiarDescr(String name) {
        return OccultismAdvancementProvider.familiarText(name, "description");
    }

    private static Path getPath(Path path, Advancement advancement) {
        ResourceLocation id = advancement.func_192067_g();
        return path.resolve("data/" + id.func_110624_b() + "/advancements/" + id.func_110623_a() + ".json");
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path folder = this.generator.func_200391_b();
        this.start();
        for (Advancement advancement : this.advancements.values()) {
            Path path = OccultismAdvancementProvider.getPath(folder, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path);
            }
            catch (IOException exception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)exception);
            }
        }
    }

    private void start() {
        Advancement root = this.add(Advancement.Builder.func_200278_a().func_200275_a("occultism_present", (ICriterionInstance)new TickTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_)).func_192056_a(new ResourceLocation("occultism", "occultism/root")));
        Advancement familiarsRoot = this.add(Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)OccultismItems.JEI_DUMMY_NONE.get(), (ITextComponent)OccultismAdvancementProvider.title("familiars"), (ITextComponent)OccultismAdvancementProvider.descr("familiars"), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false).func_200275_a("summon_familiar", (ICriterionInstance)new RitualTrigger.Instance(new RitualTrigger.RitualPredicate(null, OccultismRituals.FAMILIAR_RITUAL.getId()))).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/root")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(2), (ITextComponent)OccultismAdvancementProvider.familiarTitle("deer"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("deer"), null, FrameType.TASK, true, true, false).func_200275_a("deer_poop", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DEER_POOP)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/deer")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(0), (ITextComponent)OccultismAdvancementProvider.familiarTitle("cthulhu"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("cthulhu"), null, FrameType.TASK, true, true, false).func_200275_a("cthulhu_sad", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CTHULHU_SAD)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/cthulhu")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(1), (ITextComponent)OccultismAdvancementProvider.familiarTitle("bat"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("bat"), null, FrameType.TASK, true, true, false).func_200275_a("bat_eat", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BAT_EAT)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/bat")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(3), (ITextComponent)OccultismAdvancementProvider.familiarTitle("devil"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("devil"), null, FrameType.TASK, true, true, false).func_200275_a("devil_fire", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DEVIL_FIRE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/devil")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(4), (ITextComponent)OccultismAdvancementProvider.familiarTitle("greedy"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("greedy"), null, FrameType.TASK, true, true, false).func_200275_a("greedy_item", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GREEDY_ITEM)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/greedy")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(5), (ITextComponent)OccultismAdvancementProvider.familiarTitle("rare"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("rare"), null, FrameType.TASK, true, true, false).func_200275_a("rare_variant", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.RARE_VARIANT)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/rare")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_221778_cy, (ITextComponent)OccultismAdvancementProvider.familiarTitle("party"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("party"), null, FrameType.TASK, true, true, false).func_200275_a("party", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.PARTY)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/party")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)OccultismItems.FAMILIAR_RING.get(), (ITextComponent)OccultismAdvancementProvider.familiarTitle("capture"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("capture"), null, FrameType.TASK, true, true, false).func_200275_a("capture", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CAPTURE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/capture")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_151074_bl, (ITextComponent)OccultismAdvancementProvider.familiarTitle("dragon_nugget"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("dragon_nugget"), null, FrameType.TASK, true, true, false).func_200275_a("dragon_nugget", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_NUGGET)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/dragon_nugget")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(6), (ITextComponent)OccultismAdvancementProvider.familiarTitle("dragon_ride"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("dragon_ride"), null, FrameType.TASK, true, true, false).func_200275_a("dragon_ride", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_RIDE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/dragon_ride")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_151055_y, (ITextComponent)OccultismAdvancementProvider.familiarTitle("mans_best_friend"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("mans_best_friend"), null, FrameType.TASK, true, true, false).func_200275_a("dragon_pet", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_PET)).func_200275_a("dragon_fetch", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.DRAGON_FETCH)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/mans_best_friend")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(7), (ITextComponent)OccultismAdvancementProvider.familiarTitle("blacksmith_upgrade"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("blacksmith_upgrade"), null, FrameType.TASK, true, true, false).func_200275_a("blacksmith_upgrade", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BLACKSMITH_UPGRADE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/blacksmith_upgrade")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(8), (ITextComponent)OccultismAdvancementProvider.familiarTitle("guardian_ultimate_sacrifice"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("guardian_ultimate_sacrifice"), null, FrameType.TASK, true, true, false).func_200275_a("guardian_ultimate_sacrifice", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GUARDIAN_ULTIMATE_SACRIFICE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/guardian_ultimate_sacrifice")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(9), (ITextComponent)OccultismAdvancementProvider.familiarTitle("headless_cthulhu_head"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("headless_cthulhu_head"), null, FrameType.TASK, true, true, false).func_200275_a("headless_cthulhu_head", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/headless_cthulhu_head")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_221807_eN, (ITextComponent)OccultismAdvancementProvider.familiarTitle("headless_rebuilt"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("headless_rebuilt"), null, FrameType.TASK, true, true, false).func_200275_a("headless_rebuilt", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.HEADLESS_REBUILT)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/headless_rebuilt")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(10), (ITextComponent)OccultismAdvancementProvider.familiarTitle("chimera_ride"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("chimera_ride"), null, FrameType.TASK, true, true, false).func_200275_a("chimera_ride", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.CHIMERA_RIDE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/chimera_ride")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_151153_ao, (ITextComponent)OccultismAdvancementProvider.familiarTitle("goat_detach"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("goat_detach"), null, FrameType.TASK, true, true, false).func_200275_a("goat_detach", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.GOAT_DETACH)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/goat_detach")));
        Advancement summonShub = this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(11), (ITextComponent)OccultismAdvancementProvider.familiarTitle("shub_niggurath_summon"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("shub_niggurath_summon"), null, FrameType.TASK, true, true, false).func_200275_a("shub_niggurath_summon", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/shub_niggurath_summon")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(summonShub).func_203902_a((IItemProvider)Items.field_221620_aV, (ITextComponent)OccultismAdvancementProvider.familiarTitle("shub_cthulhu_friends"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("shub_cthulhu_friends"), null, FrameType.TASK, true, true, false).func_200275_a("shub_cthulhu_friends", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/shub_cthulhu_friends")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(summonShub).func_215092_a(this.icon(12), (ITextComponent)OccultismAdvancementProvider.familiarTitle("shub_niggurath_spawn"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("shub_niggurath_spawn"), null, FrameType.TASK, true, true, false).func_200275_a("shub_niggurath_spawn", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/shub_niggurath_spawn")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(13), (ITextComponent)OccultismAdvancementProvider.familiarTitle("beholder_ray"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("beholder_ray"), null, FrameType.TASK, true, true, false).func_200275_a("beholder_ray", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_RAY)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/beholder_ray")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_203902_a((IItemProvider)Items.field_151158_bO, (ITextComponent)OccultismAdvancementProvider.familiarTitle("beholder_eat"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("beholder_eat"), null, FrameType.TASK, true, true, false).func_200275_a("beholder_eat", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEHOLDER_EAT)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/beholder_eat")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(14), (ITextComponent)OccultismAdvancementProvider.familiarTitle("fairy_save"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("fairy_save"), null, FrameType.TASK, true, true, false).func_200275_a("fairy_save", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.FAIRY_SAVE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/fairy_save")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(15), (ITextComponent)OccultismAdvancementProvider.familiarTitle("mummy_dodge"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("mummy_dodge"), null, FrameType.TASK, true, true, false).func_200275_a("mummy_dodge", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.MUMMY_DODGE)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/mummy_dodge")));
        this.add(Advancement.Builder.func_200278_a().func_203905_a(familiarsRoot).func_215092_a(this.icon(16), (ITextComponent)OccultismAdvancementProvider.familiarTitle("beaver_woodchop"), (ITextComponent)OccultismAdvancementProvider.familiarDescr("beaver_woodchop"), null, FrameType.TASK, true, true, false).func_200275_a("beaver_woodchop", (ICriterionInstance)FamiliarTrigger.of(FamiliarTrigger.Type.BEAVER_WOODCHOP)).func_192056_a(new ResourceLocation("occultism", "occultism/familiar/beaver_woodchop")));
        this.addRitualHidden(root, "craft_dimensional_matrix");
        this.addRitualHidden(root, "craft_dimensional_mineshaft");
        this.addRitualHidden(root, "craft_familiar_ring");
        this.addRitualHidden(root, "craft_infused_lenses");
        this.addRitualHidden(root, "craft_infused_pickaxe");
        this.addRitualHidden(root, "craft_miner_djinni_ores");
        this.addRitualHidden(root, "craft_miner_foliot_unspecialized");
        this.addRitualHidden(root, "craft_satchel");
        this.addRitualHidden(root, "craft_soul_gem");
        this.addRitualHidden(root, "craft_stabilizer_tier1");
        this.addRitualHidden(root, "craft_stabilizer_tier2");
        this.addRitualHidden(root, "craft_stabilizer_tier3");
        this.addRitualHidden(root, "craft_stabilizer_tier4");
        this.addRitualHidden(root, "craft_stable_wormhole");
        this.addRitualHidden(root, "craft_storage_controller_base");
        this.addRitualHidden(root, "craft_storage_remote");
        this.addRitualHidden(root, "familiar_bat");
        this.addRitualHidden(root, "familiar_cthulhu");
        this.addRitualHidden(root, "familiar_deer");
        this.addRitualHidden(root, "familiar_devil");
        this.addRitualHidden(root, "familiar_dragon");
        this.addRitualHidden(root, "familiar_greedy");
        this.addRitualHidden(root, "familiar_otherworld_bird");
        this.addRitualHidden(root, "familiar_parrot");
        this.addRitualHidden(root, "familiar_guardian");
        this.addRitualHidden(root, "familiar_blacksmith");
        this.addRitualHidden(root, "familiar_headless");
        this.addRitualHidden(root, "familiar_chimera");
        this.addRitualHidden(root, "familiar_beholder");
        this.addRitualHidden(root, "familiar_fairy");
        this.addRitualHidden(root, "familiar_mummy");
        this.addRitualHidden(root, "familiar_beaver");
        this.addRitualHidden(root, "possess_enderman");
        this.addRitualHidden(root, "possess_endermite");
        this.addRitualHidden(root, "possess_skeleton");
        this.addRitualHidden(root, "possess_ghast");
        this.addRitualHidden(root, "summon_afrit_crusher");
        this.addRitualHidden(root, "summon_afrit_rain_weather");
        this.addRitualHidden(root, "summon_afrit_thunder_weather");
        this.addRitualHidden(root, "summon_djinni_clear_weather");
        this.addRitualHidden(root, "summon_djinni_crusher");
        this.addRitualHidden(root, "summon_djinni_day_time");
        this.addRitualHidden(root, "summon_djinni_manage_machine");
        this.addRitualHidden(root, "summon_djinni_night_time");
        this.addRitualHidden(root, "summon_foliot_cleaner");
        this.addRitualHidden(root, "summon_foliot_crusher");
        this.addRitualHidden(root, "summon_foliot_lumberjack");
        this.addRitualHidden(root, "summon_foliot_otherstone_trader");
        this.addRitualHidden(root, "summon_foliot_sapling_trader");
        this.addRitualHidden(root, "summon_foliot_transport_items");
        this.addRitualHidden(root, "summon_marid_crusher");
        this.addRitualHidden(root, "summon_wild_afrit");
        this.addRitualHidden(root, "summon_wild_hunt");
    }

    private Advancement addRitualHidden(Advancement parent, String id) {
        return this.add(Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a((IItemProvider)OccultismItems.JEI_DUMMY_NONE.get(), (ITextComponent)OccultismAdvancementProvider.title(id), (ITextComponent)OccultismAdvancementProvider.descr(id), null, FrameType.TASK, false, false, true).func_200275_a(id, (ICriterionInstance)new RitualTrigger.Instance(new RitualTrigger.RitualPredicate(new ResourceLocation("occultism", "ritual/" + id), null))).func_192056_a(new ResourceLocation("occultism", "occultism/" + id)));
    }

    private ItemStack icon(int data) {
        ItemStack icon = ((Item)OccultismItems.ADVANCEMENT_ICON.get()).func_190903_i();
        icon.func_77983_a("CustomModelData", (INBT)IntNBT.func_229692_a_((int)data));
        return icon;
    }

    private Advancement add(Advancement advancement) {
        if (this.advancements.containsKey(advancement.func_192067_g())) {
            throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
        }
        this.advancements.put(advancement.func_192067_g(), advancement);
        return advancement;
    }

    public String func_200397_b() {
        return "Advancements: occultism";
    }
}

