/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PentacleProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, JsonElement> toSerialize = new HashMap<String, JsonElement>();
    private final DataGenerator generator;

    public PentacleProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path folder = this.generator.func_200391_b();
        this.start();
        this.toSerialize.forEach((name, json) -> {
            Path path = folder.resolve("data/occultism/occultism_pentacles/" + name + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save pentacle {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Pentacles: occultism";
    }

    private void start() {
        this.addPentacle("craft_afrit", this.createPattern("     N     ", "    GGG    ", "   GCPCG   ", "  G WCW G  ", " GCWW WWCG ", "ZGPC 0 CPGZ", " GCWW WWCG ", "  G WCW G  ", "   GCPCG   ", "    GGG    ", "     Z     "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().purpleChalk().redChalk().candle().crystal().skeleton().wither().build());
        this.addPentacle("craft_djinni", this.createPattern("         ", " C WGW C ", "  P W P  ", " W SWS W ", " GWW0WWG ", " W SWS W ", "  P W P  ", " C WGW C ", "         "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().purpleChalk().candle().crystal().build());
        this.addPentacle("craft_foliot", this.createPattern("  WSW  ", " G   G ", "W  W  W", "C W0W C", "W  W  W", " G   G ", "  WSW  "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().candle().crystal().build());
        this.addPentacle("craft_marid", this.createPattern("       Z       ", "      RRR      ", "     RCWCR     ", "    R  W  R    ", "   RGSWNWSGR   ", "  R SGW WGS R  ", " RC WW   WW CR ", "ZRWWN  0  NWWRZ", " RC WW   WW CR ", "  R SGW WGS R  ", "   RGSWNWSGR   ", "    R  W  R    ", "     RCWCR     ", "      RRR      ", "       Z       "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().redChalk().candle().crystal().skeleton().wither().build());
        this.addPentacle("debug", this.createPattern("  GCG  ", " G P G ", "G  P  G", "CPP0PPC", "G  P  G", " G P G ", "  GCG  "), (Map<Character, JsonElement>)new MappingBuilder().bowl().goldChalk().purpleChalk().candle().skeleton().build());
        this.addPentacle("possess_afrit", this.createPattern("           ", "    PRP    ", "   GCWCG   ", "  G WNW G  ", " PCWP PWCP ", " RWZ 0 ZWR ", " PCWP PWCP ", "  G WNW G  ", "   GCWCG   ", "    PRP    ", "           "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().purpleChalk().redChalk().candle().skeleton().wither().build());
        this.addPentacle("possess_djinni", this.createPattern("   GPG   ", "  GC CG  ", " GZW WZG ", "GCWP PWCG", "P   0   P", "GCWP PWCG", " GZW WZG ", "  GC CG  ", "   GPG   "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().purpleChalk().candle().skeleton().build());
        this.addPentacle("possess_foliot", this.createPattern("   GGG   ", "  GC CG  ", " GW   WG ", "GC W W CG", "G   0   G", "GC W W CG", " GW   WG ", "  GC CG  ", "   GGG   "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().candle().build());
        this.addPentacle("summon_afrit", this.createPattern("           ", "    PRP    ", "   WCWCW   ", "  W WNW W  ", " PCWP PWCP ", " RWZ 0 ZWR ", " PCWP PWCP ", "  W WNW W  ", "   WCWCW   ", "    PRP    ", "           "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().purpleChalk().redChalk().candle().skeleton().wither().build());
        this.addPentacle("summon_djinni", this.createPattern("   C C   ", "   PPP   ", "  W Z W  ", "CP W W PC", " PZ 0 ZP ", "CP W W PC", "  W Z W  ", "   PPP   ", "   C C   "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().purpleChalk().candle().skeleton().build());
        this.addPentacle("summon_marid", this.createPattern("       Z       ", "      RRR      ", "     RCWCR     ", "    R  W  R    ", "   RG WNW GR   ", "  R  GW WG  R  ", " RC WW   WW CR ", "ZRWWN  0  NWWRZ", " RC WW   WW CR ", "  R  GW WG  R  ", "   RG WNW GR   ", "    R  W  R    ", "     RCWCR     ", "      RRR      ", "       Z       "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().goldChalk().redChalk().candle().skeleton().wither().build());
        this.addPentacle("summon_foliot", this.createPattern("         ", "   WCW   ", "  W W W  ", " W  W  W ", " CWW0WWC ", " W  W  W ", "  W W W  ", "   WCW   ", "         "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().candle().build());
        this.addPentacle("summon_wild_afrit", this.createPattern("           ", "    PPP    ", "   WCWCW   ", "  W WNW W  ", " PCWP PWCP ", " PWZ 0 ZWP ", " PCWP PWCP ", "  W WNW W  ", "   WCWCW   ", "    PPP    ", "           "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().purpleChalk().candle().skeleton().wither().build());
        this.addPentacle("summon_wild_greater_spirit", this.createPattern("           ", "    PPP    ", "   W W W   ", "  W WZW W  ", " P WP PW P ", " PWZ 0 ZWP ", " P WP PW P ", "  W WZW W  ", "   W W W   ", "    PPP    ", "           "), (Map<Character, JsonElement>)new MappingBuilder().bowl().whiteChalk().purpleChalk().skeleton().build());
    }

    private List<String> createPattern(String ... rows) {
        ArrayList<String> pattern = new ArrayList<String>();
        for (String row : rows) {
            pattern.add(row);
        }
        return pattern;
    }

    private void addPentacle(String name, List<String> pattern, Map<Character, JsonElement> mappings) {
        this.addPentacle(new ResourceLocation("occultism", name), pattern, mappings);
    }

    private void addPentacle(ResourceLocation rl, List<String> pattern, Map<Character, JsonElement> mappings) {
        JsonObject json = new Pentacle(rl, pattern, mappings).toJson();
        this.toSerialize.put(rl.func_110623_a(), (JsonElement)json);
    }

    private static class MappingBuilder {
        private final Map<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();

        private MappingBuilder() {
        }

        private MappingBuilder element(char c, JsonElement e) {
            this.mappings.put(Character.valueOf(c), e);
            return this;
        }

        private Map<Character, JsonElement> build() {
            return this.mappings;
        }

        private MappingBuilder block(char c, Supplier<? extends Block> b) {
            return this.element(c, (JsonElement)new JsonPrimitive(b.get().getRegistryName().toString()));
        }

        private MappingBuilder blockDisplay(char c, Supplier<? extends Block> b, Supplier<? extends Block> display) {
            JsonObject json = new JsonObject();
            json.add("block", (JsonElement)new JsonPrimitive(b.get().getRegistryName().toString()));
            json.add("display", (JsonElement)new JsonPrimitive(display.get().getRegistryName().toString()));
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder tag(char c, ITag.INamedTag<Block> tag, Supplier<? extends Block> display) {
            JsonObject json = new JsonObject();
            json.add("tag", (JsonElement)new JsonPrimitive(tag.func_230234_a_().toString()));
            json.add("display", (JsonElement)new JsonPrimitive(display.get().getRegistryName().toString()));
            return this.element(c, (JsonElement)json);
        }

        private MappingBuilder bowl() {
            return this.block('0', (Supplier<? extends Block>)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL);
        }

        private MappingBuilder candle() {
            return this.tag('C', OccultismTags.CANDLES, (Supplier<? extends Block>)OccultismBlocks.CANDLE_WHITE);
        }

        private MappingBuilder whiteChalk() {
            return this.block('W', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_WHITE);
        }

        private MappingBuilder goldChalk() {
            return this.block('G', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_GOLD);
        }

        private MappingBuilder purpleChalk() {
            return this.block('P', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_PURPLE);
        }

        private MappingBuilder redChalk() {
            return this.block('R', (Supplier<? extends Block>)OccultismBlocks.CHALK_GLYPH_RED);
        }

        private MappingBuilder crystal() {
            return this.block('S', (Supplier<? extends Block>)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL);
        }

        private MappingBuilder skeleton() {
            return this.blockDisplay('Z', (Supplier<? extends Block>)((Supplier<Block>)() -> Blocks.field_196703_eM), (Supplier<? extends Block>)OccultismBlocks.SKELETON_SKULL_DUMMY);
        }

        private MappingBuilder wither() {
            return this.blockDisplay('N', (Supplier<? extends Block>)((Supplier<Block>)() -> Blocks.field_196705_eO), (Supplier<? extends Block>)OccultismBlocks.WITHER_SKELETON_SKULL_DUMMY);
        }
    }
}

