/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.BeaverFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FairyFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GuardianFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.HeadlessFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FamiliarEventHandler {
    @SubscribeEvent
    public static void beaverFindTree(SaplingGrowTreeEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        List beavers = event.getWorld().func_175647_a(BeaverFamiliarEntity.class, new AxisAlignedBB(pos).func_186662_g(30.0), b -> !b.isSitting() && b.isEffectEnabled(b.getFamiliarOwner()));
        if (!beavers.isEmpty()) {
            BeaverFamiliarEntity beaver = (BeaverFamiliarEntity)beavers.get(world.func_201674_k().nextInt(beavers.size()));
            beaver.setTreeTarget(pos);
        }
    }

    @SubscribeEvent
    public static void beaverHarvest(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (!event.getState().func_235714_a_((ITag)BlockTags.field_200031_h)) {
            return;
        }
        if (!player.func_70644_a((Effect)OccultismEffects.BEAVER_HARVEST.get())) {
            return;
        }
        int level = player.func_70660_b((Effect)OccultismEffects.BEAVER_HARVEST.get()).func_76458_c();
        event.setNewSpeed(event.getNewSpeed() * (float)(level + 3));
    }

    @SubscribeEvent
    public static void dodge(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.func_70644_a((Effect)OccultismEffects.MUMMY_DODGE.get())) {
            return;
        }
        DamageSource source = event.getSource();
        if (!(source instanceof EntityDamageSource) || source.func_94541_c() || source.func_76357_e()) {
            return;
        }
        int level = entity.func_70660_b((Effect)OccultismEffects.MUMMY_DODGE.get()).func_76458_c();
        boolean dodge = entity.func_70681_au().nextDouble() < (double)((float)(level + 1) * 0.1f);
        event.setCanceled(dodge);
        if (dodge) {
            OccultismAdvancements.FAMILIAR.trigger(entity, FamiliarTrigger.Type.MUMMY_DODGE);
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        FamiliarEventHandler.guardianUltimateSacrifice(event);
        FamiliarEventHandler.headlessStealHead(event);
        FamiliarEventHandler.fairySave(event);
        FamiliarEventHandler.lifesteal(event);
    }

    private static void lifesteal(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
        if (!attacker.func_70644_a((Effect)OccultismEffects.BAT_LIFESTEAL.get())) {
            return;
        }
        attacker.func_70691_i((float)(1 + attacker.func_70660_b((Effect)OccultismEffects.BAT_LIFESTEAL.get()).func_76458_c()));
    }

    private static void fairySave(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().func_76357_e() || !(entity instanceof IFamiliar) || entity.func_200600_R() == OccultismEntities.GUARDIAN_FAMILIAR.get() || entity.func_200600_R() == OccultismEntities.FAIRY_FAMILIAR.get()) {
            return;
        }
        IFamiliar familiar = (IFamiliar)entity;
        LivingEntity owner = familiar.getFamiliarOwner();
        if (owner == null || !FamiliarUtil.isFamiliarEnabled(owner, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.FAIRY_FAMILIAR.get()))) {
            return;
        }
        FairyFamiliarEntity fairy = (FairyFamiliarEntity)FamiliarUtil.getFamiliar(owner, (EntityType)OccultismEntities.FAIRY_FAMILIAR.get());
        if (fairy == null || !fairy.saveFamiliar(familiar)) {
            return;
        }
        event.setCanceled(true);
        entity.func_70606_j(2.0f);
        entity.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 2));
        if (!owner.field_70170_p.field_72995_K) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.FAIRY_SAVE);
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent event) {
        if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get()))) {
            return;
        }
        EntityType headType = event.getEntityLiving().func_200600_R();
        if (!FamiliarUtil.hasFamiliar((LivingEntity)player, (EntityType)OccultismEntities.HEADLESS_FAMILIAR.get(), h -> h.getHeadType() == headType)) {
            return;
        }
        event.setAmount(event.getAmount() * 1.3f);
    }

    private static void headlessStealHead(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get()))) {
            return;
        }
        List<HeadlessFamiliarEntity> headlesses = FamiliarUtil.getAllFamiliars((LivingEntity)player, (EntityType)OccultismEntities.HEADLESS_FAMILIAR.get());
        if (!headlesses.isEmpty() && event.getEntityLiving().func_200600_R() == OccultismEntities.CTHULHU_FAMILIAR.get()) {
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)player, FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD);
        }
        headlesses.forEach(h -> h.setHeadType(event.getEntityLiving().func_200600_R()));
    }

    private static void guardianUltimateSacrifice(LivingDeathEvent event) {
        if (event.getSource().func_76357_e() || !(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get()))) {
            return;
        }
        GuardianFamiliarEntity guardian = (GuardianFamiliarEntity)FamiliarUtil.getFamiliar((LivingEntity)player, (EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get());
        if (guardian == null) {
            return;
        }
        if (!guardian.sacrifice()) {
            return;
        }
        event.setCanceled(true);
        player.func_70606_j(1.0f);
        player.func_195061_cb();
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
    }

    @SubscribeEvent
    public static void beholderBlindnessImmune(PotionEvent.PotionApplicableEvent event) {
        EntityType beholder;
        if (event.getPotionEffect().func_188419_a() != Effects.field_76440_q) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!FamiliarUtil.hasFamiliar(entity, beholder = (EntityType)OccultismEntities.BEHOLDER_FAMILIAR.get(), b -> b.hasBlacksmithUpgrade())) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }
}

