/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.entity.FairyFamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageFairySupport
extends MessageBase {
    private int fairyId;
    private int targetId;

    public MessageFairySupport(int fairyId, int targetId) {
        this.fairyId = fairyId;
        this.targetId = targetId;
    }

    public MessageFairySupport(PacketBuffer buf) {
        this.decode(buf);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.fairyId);
        buf.writeInt(this.targetId);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.fairyId = buf.readInt();
        this.targetId = buf.readInt();
    }

    @Override
    public void onClientReceived(Minecraft minecraft, PlayerEntity player, NetworkEvent.Context context) {
        Entity target;
        Entity fairy = minecraft.field_71441_e.func_73045_a(this.fairyId);
        if (fairy instanceof FairyFamiliarEntity) {
            ((FairyFamiliarEntity)fairy).startSupportAnimation();
        }
        if ((target = minecraft.field_71441_e.func_73045_a(this.targetId)) != null) {
            for (int i = 0; i < 30; ++i) {
                Vector3d pos = new Vector3d(target.func_226282_d_(1.0), target.func_226279_cv_(), target.func_226287_g_(1.0));
                minecraft.field_71441_e.func_195594_a((IParticleData)new RedstoneParticleData(0.9f, 0.9f, 0.5f, 1.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }
}

