/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetManagedMachine
extends MessageBase {
    public MachineReference managedMachine;

    public MessageSetManagedMachine(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageSetManagedMachine(MachineReference managedMachine) {
        this.managedMachine = managedMachine;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_77973_b() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
                if (job.getManagedMachine() != null) {
                    job.getManagedMachine().customName = this.managedMachine.customName;
                    job.getManagedMachine().extractFacing = this.managedMachine.extractFacing;
                    job.getManagedMachine().insertFacing = this.managedMachine.insertFacing;
                    ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                    player.field_71069_bz.func_75142_b();
                }
            }));
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        this.managedMachine.encode(buf);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.managedMachine = MachineReference.from(buf);
    }
}

