/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.StorageUtil;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class MessageSetRecipeByID
extends MessageBase {
    private ResourceLocation id;

    public MessageSetRecipeByID(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageSetRecipeByID(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        if (!(player.field_71070_bA instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        IRecipe recipe = player.func_130014_f_().func_199532_z().func_215367_a(this.id).orElse(null);
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0);
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingInventory craftMatrix = container.getCraftMatrix();
        NonNullList<Ingredient> ingredients = this.getIngredientsForRecipe(recipe);
        for (int slot = 0; slot < 9; ++slot) {
            Ingredient ingredient = (Ingredient)ingredients.get(slot);
            ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), (Predicate<ItemStack>)ingredient, 1, true);
            if (extractedStack != null && !extractedStack.func_190926_b() && craftMatrix.func_70301_a(slot).func_190926_b()) {
                StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), (Predicate<ItemStack>)ingredient, 1, false);
                craftMatrix.func_70299_a(slot, extractedStack);
                continue;
            }
            extractedStack = storageController.getOneOfMostCommonItem((Predicate<ItemStack>)ingredient, false);
            if (extractedStack.func_190926_b() || !craftMatrix.func_70301_a(slot).func_190926_b()) continue;
            craftMatrix.func_70299_a(slot, extractedStack);
        }
        container.updateCraftingSlots(true);
        OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.id);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.id = buf.func_192575_l();
    }

    private NonNullList<Ingredient> getIngredientsForRecipe(IRecipe<?> recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        NonNullList ingredientsMatrixGrid = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            int width = shapedRecipe.getRecipeWidth();
            int height = shapedRecipe.getRecipeHeight();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    ingredientsMatrixGrid.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredientsMatrixGrid.set(i, ingredients.get(i));
            }
        }
        return ingredientsMatrixGrid;
    }
}

