/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSplitPacket {
    private final byte[] payload;
    private final int communicationId;
    private final int packetIndex;

    public MessageSplitPacket(int communicationId, int packetIndex, byte[] payload) {
        this.communicationId = communicationId;
        this.packetIndex = packetIndex;
        this.payload = payload;
    }

    public static void encode(MessageSplitPacket message, PacketBuffer buf) {
        buf.func_150787_b(message.communicationId);
        buf.func_150787_b(message.packetIndex);
        buf.func_179250_a(message.payload);
    }

    public static MessageSplitPacket decode(PacketBuffer buf) {
        return new MessageSplitPacket(buf.func_150792_a(), buf.func_150792_a(), buf.func_179251_a());
    }

    public static boolean handle(MessageSplitPacket data, Supplier<NetworkEvent.Context> ctx) {
        OccultismPackets.addPackagePart(data.communicationId, data.packetIndex, data.payload);
        ctx.get().setPacketHandled(true);
        return true;
    }
}

