/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageToggleFamiliarSettings
extends MessageBase {
    public Map<EntityType<?>, Boolean> familiarsPressed;

    public MessageToggleFamiliarSettings(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageToggleFamiliarSettings(Map<EntityType<?>, Boolean> familiarsPressed) {
        this.familiarsPressed = familiarsPressed;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        player.getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).ifPresent(cap -> {
            for (Map.Entry<EntityType<?>, Boolean> toggle : this.familiarsPressed.entrySet()) {
                if (!toggle.getValue().booleanValue()) continue;
                cap.setFamiliarEnabled(toggle.getKey(), !cap.isFamiliarEnabled(toggle.getKey()));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.occultism.familiar." + toggle.getKey().getRegistryName().func_110623_a() + (cap.isFamiliarEnabled(toggle.getKey()) ? ".enabled" : ".disabled")), true);
            }
        });
    }

    @Override
    public void encode(PacketBuffer buf) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            buf.writeBoolean(this.familiarsPressed.get(familiar).booleanValue());
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.familiarsPressed = new HashMap();
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            this.familiarsPressed.put(familiar, buf.readBoolean());
        }
    }
}

