/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.network.MessageBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateLinkedMachines
extends MessageBase {
    private List<MachineReference> linkedMachines;

    public MessageUpdateLinkedMachines(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageUpdateLinkedMachines(List<MachineReference> linkedMachines) {
        this.linkedMachines = linkedMachines;
    }

    public MessageUpdateLinkedMachines(Map<GlobalBlockPos, MachineReference> linkedMachines) {
        this.linkedMachines = new ArrayList<MachineReference>(linkedMachines.values());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientReceived(Minecraft minecraft, PlayerEntity player, NetworkEvent.Context context) {
        IStorageControllerGui gui;
        if (minecraft.field_71462_r instanceof IStorageControllerGui && (gui = (IStorageControllerGui)minecraft.field_71462_r) != null) {
            gui.setLinkedMachines(this.linkedMachines);
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.linkedMachines.size());
        for (MachineReference machineReference : this.linkedMachines) {
            machineReference.encode(buf);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        int linkedMachinesSize = buf.readInt();
        this.linkedMachines = new ArrayList<MachineReference>(linkedMachinesSize);
        for (int i = 0; i < linkedMachinesSize; ++i) {
            MachineReference machineReference = MachineReference.from(buf);
            this.linkedMachines.add(machineReference);
        }
    }
}

