/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.github.klikli_dev.occultism.network.MessageBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateStacks
extends MessageBase {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private List<ItemStack> stacks;
    private int usedSlots;
    private int maxSlots;
    private ByteBuf payload;

    public MessageUpdateStacks(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageUpdateStacks(List<ItemStack> stacks, int usedSlots, int maxSlots) {
        this.stacks = stacks;
        this.usedSlots = usedSlots;
        this.maxSlots = maxSlots;
        this.compress();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientReceived(Minecraft minecraft, PlayerEntity player, NetworkEvent.Context context) {
        IStorageControllerGui gui;
        this.uncompress();
        if (minecraft.field_71462_r instanceof IStorageControllerGui && (gui = (IStorageControllerGui)minecraft.field_71462_r) != null) {
            gui.setStacks(this.stacks);
            gui.setUsedSlots(this.usedSlots);
            gui.setMaxSlots(this.maxSlots);
            gui.markDirty();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.usedSlots);
        buf.func_150787_b(this.maxSlots);
        buf.func_150787_b(this.payload.readableBytes());
        buf.writeBytes(this.payload, 0, this.payload.readableBytes());
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.usedSlots = buf.func_150792_a();
        this.maxSlots = buf.func_150792_a();
        int compressedSize = buf.func_150792_a();
        this.payload = Unpooled.buffer((int)compressedSize);
        buf.readBytes(this.payload, 0, compressedSize);
    }

    public void uncompress() {
        Inflater decompressor = new Inflater();
        decompressor.setInput(this.payload.array());
        PacketBuffer uncompressed = new PacketBuffer(Unpooled.buffer((int)(this.payload.readableBytes() * 4)));
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                uncompressed.writeBytes(buf, 0, count);
            }
            catch (Exception count) {}
        }
        int stacksSize = uncompressed.readInt();
        this.stacks = new ArrayList<ItemStack>(stacksSize);
        for (int i = 0; i < stacksSize; ++i) {
            ItemStack stack = uncompressed.func_150791_c();
            stack.func_190920_e(uncompressed.readInt());
            this.stacks.add(stack);
        }
    }

    public void compress() {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        PacketBuffer uncompressed = new PacketBuffer(Unpooled.buffer((int)(2048 * this.stacks.size())));
        uncompressed.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            uncompressed.func_150788_a(stack);
            uncompressed.writeInt(stack.func_190916_E());
        }
        compressor.setInput(uncompressed.array(), 0, uncompressed.readableBytes());
        compressor.finish();
        this.payload = Unpooled.buffer((int)2048);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            this.payload.writeBytes(buf, 0, count);
        }
    }
}

