/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class OccultismPacketHandler {
    public static <T extends IMessage> void handle(T message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> OccultismPacketHandler.handleServer(message, ctx));
        } else {
            ctx.get().enqueueWork(() -> OccultismPacketHandler.handleClient(message, ctx));
        }
        ctx.get().setPacketHandled(true);
    }

    public static <T extends IMessage> void handleServer(T message, Supplier<NetworkEvent.Context> ctx) {
        MinecraftServer server = ctx.get().getSender().field_70170_p.func_73046_m();
        message.onServerReceived(server, ctx.get().getSender(), ctx.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends IMessage> void handleClient(T message, Supplier<NetworkEvent.Context> ctx) {
        Minecraft minecraft = Minecraft.func_71410_x();
        message.onClientReceived(minecraft, (PlayerEntity)minecraft.field_71439_g, ctx.get());
    }
}

