/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.network.MessageBeholderAttack;
import com.github.klikli_dev.occultism.network.MessageClearCraftingMatrix;
import com.github.klikli_dev.occultism.network.MessageDoubleJump;
import com.github.klikli_dev.occultism.network.MessageFairySupport;
import com.github.klikli_dev.occultism.network.MessageHeadlessDie;
import com.github.klikli_dev.occultism.network.MessageInsertMouseHeldItem;
import com.github.klikli_dev.occultism.network.MessageOpenSatchel;
import com.github.klikli_dev.occultism.network.MessageOpenStorageRemote;
import com.github.klikli_dev.occultism.network.MessageRequestOrder;
import com.github.klikli_dev.occultism.network.MessageRequestStacks;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.MessageSetDivinationResult;
import com.github.klikli_dev.occultism.network.MessageSetFilterMode;
import com.github.klikli_dev.occultism.network.MessageSetItemMode;
import com.github.klikli_dev.occultism.network.MessageSetJumps;
import com.github.klikli_dev.occultism.network.MessageSetManagedMachine;
import com.github.klikli_dev.occultism.network.MessageSetRecipe;
import com.github.klikli_dev.occultism.network.MessageSetRecipeByID;
import com.github.klikli_dev.occultism.network.MessageSetTagFilterText;
import com.github.klikli_dev.occultism.network.MessageSetWorkAreaSize;
import com.github.klikli_dev.occultism.network.MessageSortItems;
import com.github.klikli_dev.occultism.network.MessageTakeItem;
import com.github.klikli_dev.occultism.network.MessageToggleFamiliarSettings;
import com.github.klikli_dev.occultism.network.MessageUpdateLinkedMachines;
import com.github.klikli_dev.occultism.network.MessageUpdateMouseHeldItem;
import com.github.klikli_dev.occultism.network.MessageUpdatePentacles;
import com.github.klikli_dev.occultism.network.MessageUpdateStacks;
import com.github.klikli_dev.occultism.network.OccultismPacketHandler;
import com.github.klikli_dev.occultism.network.PacketSplitter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class OccultismPackets {
    public static final String PROTOCOL_VERSION = "1";
    public static final ResourceLocation CHANNEL = new ResourceLocation("occultism", "main");
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL, () -> "1", "1"::equals, "1"::equals);
    public static final PacketSplitter SPLITTER = new PacketSplitter(5, INSTANCE, CHANNEL);
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageRequestStacks.class, MessageRequestStacks::encode, MessageRequestStacks::new, OccultismPacketHandler::handle);
        SPLITTER.registerMessage(OccultismPackets.nextID(), MessageUpdateLinkedMachines.class, MessageUpdateLinkedMachines::encode, MessageUpdateLinkedMachines::new, OccultismPacketHandler::handle);
        SPLITTER.registerMessage(OccultismPackets.nextID(), MessageUpdateStacks.class, MessageUpdateStacks::encode, MessageUpdateStacks::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetRecipe.class, MessageSetRecipe::encode, MessageSetRecipe::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageClearCraftingMatrix.class, MessageClearCraftingMatrix::encode, MessageClearCraftingMatrix::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageTakeItem.class, MessageTakeItem::encode, MessageTakeItem::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageUpdateMouseHeldItem.class, MessageUpdateMouseHeldItem::encode, MessageUpdateMouseHeldItem::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageInsertMouseHeldItem.class, MessageInsertMouseHeldItem::encode, MessageInsertMouseHeldItem::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageRequestOrder.class, MessageRequestOrder::encode, MessageRequestOrder::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSortItems.class, MessageSortItems::encode, MessageSortItems::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetItemMode.class, MessageSetItemMode::encode, MessageSetItemMode::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetWorkAreaSize.class, MessageSetWorkAreaSize::encode, MessageSetWorkAreaSize::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetManagedMachine.class, MessageSetManagedMachine::encode, MessageSetManagedMachine::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetDivinationResult.class, MessageSetDivinationResult::encode, MessageSetDivinationResult::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSelectBlock.class, MessageSelectBlock::encode, MessageSelectBlock::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetJumps.class, MessageSetJumps::encode, MessageSetJumps::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageDoubleJump.class, MessageDoubleJump::encode, MessageDoubleJump::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetFilterMode.class, MessageSetFilterMode::encode, MessageSetFilterMode::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetRecipeByID.class, MessageSetRecipeByID::encode, MessageSetRecipeByID::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageOpenSatchel.class, MessageOpenSatchel::encode, MessageOpenSatchel::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageSetTagFilterText.class, MessageSetTagFilterText::encode, MessageSetTagFilterText::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageToggleFamiliarSettings.class, MessageToggleFamiliarSettings::encode, MessageToggleFamiliarSettings::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageOpenStorageRemote.class, MessageOpenStorageRemote::encode, MessageOpenStorageRemote::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageUpdatePentacles.class, MessageUpdatePentacles::encode, MessageUpdatePentacles::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageHeadlessDie.class, MessageHeadlessDie::encode, MessageHeadlessDie::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageBeholderAttack.class, MessageBeholderAttack::encode, MessageBeholderAttack::new, OccultismPacketHandler::handle);
        INSTANCE.registerMessage(OccultismPackets.nextID(), MessageFairySupport.class, MessageFairySupport::encode, MessageFairySupport::new, OccultismPacketHandler::handle);
    }

    public static <MSG> void sendToTracking(Entity entity, MSG message) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <MSG> void sendToDimension(RegistryKey<World> dimensionKey, MSG message) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dimensionKey), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        if (SPLITTER.shouldMessageBeSplit(message.getClass())) {
            SPLITTER.sendToServer(message);
        } else {
            INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
        }
    }

    public static <MSG> void sendTo(ServerPlayerEntity player, MSG message) {
        if (!(player instanceof FakePlayer)) {
            if (SPLITTER.shouldMessageBeSplit(message.getClass())) {
                SPLITTER.sendToPlayer(player, message);
            } else {
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
            }
        }
    }

    public static void addPackagePart(int communicationId, int packetIndex, byte[] payload) {
        SPLITTER.addPackagePart(communicationId, packetIndex, payload);
    }
}

