/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.common.item.armor.OtherworldGogglesItem;
import com.github.klikli_dev.occultism.common.item.storage.SatchelItem;
import com.github.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static boolean hasGoggles(PlayerEntity player) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() instanceof OtherworldGogglesItem) {
            return true;
        }
        Optional<Boolean> hasGoggles = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> curiosHandler.getCurios().values()).map(slotsHandler -> slotsHandler.stream().map(ICurioStacksHandler::getStacks).map(stackHandler -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof OtherworldGogglesItem)) continue;
                return true;
            }
            return false;
        })).map(results -> results.anyMatch(found -> found));
        return hasGoggles.orElse(false);
    }

    public static ItemStack getBackpack(PlayerEntity player) {
        Optional hasBackpack = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> {
            Optional<ItemStack> hasBackpackStack = curiosHandler.getStacksHandler(SlotTypePreset.BELT.getIdentifier()).map(slotHandler -> {
                IDynamicStackHandler stackHandler = slotHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
                    return stack;
                }
                return ItemStack.field_190927_a;
            });
            return hasBackpackStack.orElse(ItemStack.field_190927_a);
        });
        return hasBackpack.orElse(ItemStack.field_190927_a);
    }

    public static SelectedCurio getStorageRemote(PlayerEntity player) {
        int selectedSlot = player.field_71071_by.field_70461_c;
        ItemStack storageRemoteStack = player.field_71071_by.func_70448_g();
        if (!(storageRemoteStack.func_77973_b() instanceof StorageRemoteItem)) {
            selectedSlot = -1;
            storageRemoteStack = CuriosUtil.getStorageRemoteCurio(player);
        }
        if (!(storageRemoteStack.func_77973_b() instanceof StorageRemoteItem)) {
            selectedSlot = CuriosUtil.getFirstStorageRemoteSlot(player);
            ItemStack itemStack = storageRemoteStack = selectedSlot > 0 ? player.field_71071_by.func_70301_a(selectedSlot) : ItemStack.field_190927_a;
        }
        if (storageRemoteStack.func_77973_b() instanceof StorageRemoteItem) {
            return new SelectedCurio(storageRemoteStack, selectedSlot);
        }
        return null;
    }

    public static ItemStack getStorageRemoteCurio(PlayerEntity player) {
        Optional hasStorageRemote = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> {
            for (ICurioStacksHandler curiosStackshandler : curiosHandler.getCurios().values()) {
                IDynamicStackHandler stackHandler = curiosStackshandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof StorageRemoteItem)) continue;
                    return stack;
                }
            }
            return ItemStack.field_190927_a;
        });
        return hasStorageRemote.orElse(ItemStack.field_190927_a);
    }

    public static int getFirstBackpackSlot(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstStorageRemoteSlot(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!(stack.func_77973_b() instanceof StorageRemoteItem)) continue;
            return slot;
        }
        return -1;
    }

    public static class SelectedCurio {
        public ItemStack itemStack;
        public int selectedSlot;

        public SelectedCurio(ItemStack itemStack, int selectedSlot) {
            this.itemStack = itemStack;
            this.selectedSlot = selectedSlot;
        }
    }
}

