/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityUtil {
    public static Optional<ServerPlayerEntity> getPlayerByUuiDGlobal(UUID uuid) {
        for (ServerWorld world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            ServerPlayerEntity player = (ServerPlayerEntity)world.func_217371_b(uuid);
            if (player == null) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(UUID uuid) {
        return EntityUtil.getEntityByUuiDGlobal(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerWorld world : server.func_212370_w()) {
                Entity entity = world.func_217461_a(uuid);
                if (entity == null) continue;
                return Optional.of(entity);
            }
        }
        return Optional.empty();
    }

    public static Entity entityFromNBT(World world, CompoundNBT nbtTagCompound) {
        ResourceLocation typeId = new ResourceLocation(nbtTagCompound.func_74779_i("id"));
        Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(typeId)).func_200721_a(world);
        entity.deserializeNBT(nbtTagCompound);
        return entity;
    }

    public static EntityType<?> entityTypeFromNbt(CompoundNBT nbtTagCompound) {
        ResourceLocation typeId = new ResourceLocation(nbtTagCompound.func_74779_i("id"));
        return (EntityType)ForgeRegistries.ENTITIES.getValue(typeId);
    }
}

