/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TileEntityUtil {
    public static TileEntity get(World world, GlobalBlockPos pos) {
        if (pos == null) {
            return null;
        }
        if (world.func_234923_W_() == pos.getDimensionKey()) {
            return TileEntityUtil.getWorldTileEntityUnchecked(world, pos.getPos());
        }
        if (world.field_72995_K) {
            return null;
        }
        ServerWorld dimensionWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(pos.getDimensionKey());
        if (dimensionWorld != null) {
            return TileEntityUtil.getWorldTileEntityUnchecked((World)dimensionWorld, pos.getPos());
        }
        return null;
    }

    @Nullable
    public static TileEntity getWorldTileEntityUnchecked(World world, BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        TileEntity tileentity = null;
        if (world.field_147481_N) {
            tileentity = world.func_189508_F(pos);
        }
        if (tileentity == null) {
            tileentity = world.func_175726_f(pos).func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = world.func_189508_F(pos);
        }
        return tileentity;
    }

    public static void updateTile(World world, BlockPos pos) {
        if (world == null || world.field_72995_K || !world.func_175667_e(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 2);
        world.func_175646_b(pos, world.func_175625_s(pos));
    }

    public static boolean hasCapabilityOnAnySide(TileEntity tileEntity, Capability<?> capability) {
        for (Direction face : Direction.values()) {
            if (!tileEntity.getCapability(capability, face).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static ItemEntity getDroppedItemWithNbt(ItemStack itemStack, TileEntity tileEntity) {
        CompoundNBT compoundnbt = tileEntity.serializeNBT();
        if (!compoundnbt.isEmpty()) {
            itemStack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        ItemEntity itementity = new ItemEntity(tileEntity.func_145831_w(), (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), itemStack);
        itementity.func_174869_p();
        return itementity;
    }

    public static void onBlockChangeDropWithNbt(Block block, BlockState state, World world, BlockPos pos, BlockState newState) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile;
            if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null) {
                world.func_217376_c((Entity)TileEntityUtil.getDroppedItemWithNbt(new ItemStack((IItemProvider)block), tile));
            }
            world.func_175666_e(pos, block);
        }
    }

    public static ItemStack getItemWithNbt(Block block, IBlockReader world, BlockPos pos) {
        ItemStack itemStack = new ItemStack((IItemProvider)block);
        TileEntity tileEntity = world.func_175625_s(pos);
        CompoundNBT compoundnbt = tileEntity.serializeNBT();
        if (!compoundnbt.isEmpty()) {
            itemStack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemStack;
    }
}

